function [d, dC] = choiceMat2Struct(dataMat) 
%% d = choiceMat2Struct(dataMat) 
% 
% Converts a data matrix w/ standard behavioral measurements into a structure
% to be used for fitting with Gabe's code. 
% 
% dataMat is an nTrials x 3 matrix with fields:
% 
% [signedCoherence    choice(0 for left, 1 for right)     RT(in seconds)]



coh = dataMat(:,1);
usCoh = unique(coh) ;

for i = 1:length(usCoh)
    n(i) = sum(coh == usCoh(i)) ;
end

maxnTrials = max(n) ;

for i = 1:length(usCoh) 
    
    l = coh == usCoh(i) ;
    n = sum(l) ;
    
    d(i).nTrials = n ;
    d(i).coherence = usCoh(i) ;
    d(i).choice = nan(maxnTrials,1) ;
    d(i).RTs = nan(maxnTrials,1) ;
    
    d(i).choice(1:n) = dataMat(l,2) ;
    d(i).RTs(1:n) = dataMat(l,3) ;
    
end



uCoh = unique(abs(coh)) ;

for i = 1:length(uCoh)
    n(i) = sum(coh == uCoh(i)) ;
end

maxnTrials = max(n) ;

for i = 1:length(uCoh) 
    
    l = coh == uCoh(i) ;
    n = sum(l) ;
    
    dC(i).nTrials = n ;
    dC(i).coherence = uCoh(i) ;
    dC(i).choice = nan(maxnTrials,1) ;
    dC(i).RTs = nan(maxnTrials,1) ;
    
    dC(i).choice(1:n) = dataMat(l,2) ;
    dC(i).RTs(1:n) = dataMat(l,3) ;
    dC(i).correct(1:n) = logical(sign(dataMat(l,1))) == logical(dataMat(l,2)) ;
end
    